/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.resource.pojo.data.gun;

import com.google.common.collect.Maps;
import com.tacz.guns.api.entity.IGunOperator;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1309;
import net.minecraft.class_4050;

public enum InaccuracyType {
    STAND,
    MOVE,
    SNEAK,
    LIE,
    AIM;


    public static InaccuracyType getInaccuracyType(class_1309 livingEntity) {
        float aimingProgress = IGunOperator.fromLivingEntity(livingEntity).getSynAimingProgress();
        if (aimingProgress == 1.0f) {
            return AIM;
        }
        if (!livingEntity.method_5681() && livingEntity.method_18376() == class_4050.field_18079) {
            return LIE;
        }
        if (livingEntity.method_18376() == class_4050.field_18081) {
            return SNEAK;
        }
        if (InaccuracyType.isMove(livingEntity)) {
            return MOVE;
        }
        return STAND;
    }

    public static Map<InaccuracyType, Float> getDefaultInaccuracy() {
        HashMap inaccuracy = Maps.newHashMap();
        inaccuracy.put(STAND, Float.valueOf(5.0f));
        inaccuracy.put(MOVE, Float.valueOf(5.75f));
        inaccuracy.put(SNEAK, Float.valueOf(3.5f));
        inaccuracy.put(LIE, Float.valueOf(2.5f));
        inaccuracy.put(AIM, Float.valueOf(0.15f));
        return inaccuracy;
    }

    private static boolean isMove(class_1309 livingEntity) {
        double distance = Math.abs(livingEntity.field_5973 - livingEntity.field_6039);
        return distance > (double)0.05f;
    }

    public boolean isAim() {
        return this == AIM;
    }
}

